/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class ArrayIndex
extends AColIndex {
    private final int[] cols;

    public ArrayIndex(int[] cols) {
        this.cols = cols;
    }

    @Override
    public int size() {
        return this.cols.length;
    }

    @Override
    public int get(int i) {
        return this.cols[i];
    }

    @Override
    public IColIndex shift(int i) {
        int[] ret = new int[this.cols.length];
        for (int j = 0; j < this.cols.length; ++j) {
            ret[j] = this.cols[j] + i;
        }
        return new ArrayIndex(ret);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.cols.length < 100) {
            this.writeBuffered(out);
        } else {
            this.writeGeneric(out);
        }
    }

    public void writeBuffered(DataOutput out) throws IOException {
        byte[] o = new byte[this.cols.length * 4 + 4 + 1];
        o[0] = (byte)IColIndex.ColIndexType.ARRAY.ordinal();
        IOUtilFunctions.intToBa(this.cols.length, o, 1);
        for (int i = 0; i < this.cols.length; ++i) {
            IOUtilFunctions.intToBa(this.cols[i], o, i * 4 + 5);
        }
        out.write(o);
    }

    public void writeGeneric(DataOutput out) throws IOException {
        int of;
        byte[] o = new byte[512];
        o[0] = (byte)IColIndex.ColIndexType.ARRAY.ordinal();
        IOUtilFunctions.intToBa(this.cols.length, o, 1);
        out.write(o, 0, 5);
        int i = 0;
        while (i + 128 < this.cols.length) {
            of = 0;
            while (of < o.length) {
                IOUtilFunctions.intToBa(this.cols[i], o, of);
                of += 4;
                ++i;
            }
            out.write(o);
        }
        of = 0;
        while (i < this.cols.length) {
            IOUtilFunctions.intToBa(this.cols[i], o, of);
            of += 4;
            ++i;
        }
        out.write(o, 0, of);
    }

    public static ArrayIndex read(DataInput in) throws IOException {
        int size = in.readInt();
        int[] cols = new int[size];
        for (int i = 0; i < size; ++i) {
            cols[i] = in.readInt();
        }
        return new ArrayIndex(cols);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5 + 4 * this.cols.length;
    }

    @Override
    public long estimateInMemorySize() {
        return ArrayIndex.estimateInMemorySizeStatic(this.cols.length);
    }

    public static long estimateInMemorySizeStatic(int nCol) {
        return 16L + (long)MemoryEstimates.intArrayCost(nCol);
    }

    @Override
    public IIterate iterator() {
        return new ArrayIterator();
    }

    @Override
    public int findIndex(int i) {
        return Arrays.binarySearch(this.cols, i);
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        if (l == 0 && u > this.cols[this.cols.length - 1]) {
            return new IColIndex.SliceResult(0, this.cols.length, this);
        }
        int s = Arrays.binarySearch(this.cols, l);
        int e = Arrays.binarySearch(this.cols, u);
        s = s < 0 ? Math.abs(s + 1) : s;
        int n = e = e < 0 ? Math.abs(e + 1) : e;
        if (s == e) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        int[] retArr = new int[e - s];
        if (l == 0) {
            retArr = Arrays.copyOfRange(this.cols, s, e);
        } else {
            int i = s;
            int j = 0;
            while (i < e) {
                retArr[j] = this.cols[i] - l;
                ++i;
                ++j;
            }
        }
        IColIndex.SliceResult ret = new IColIndex.SliceResult(s, e, ColIndexFactory.create(retArr));
        return ret;
    }

    @Override
    public boolean equals(IColIndex other) {
        if (other.size() == this.size()) {
            if (other instanceof ArrayIndex) {
                ArrayIndex ot = (ArrayIndex)other;
                int[] otV = ot.cols;
                return Arrays.equals(this.cols, otV);
            }
            if (other instanceof RangeIndex) {
                return other.get(0) == this.cols[0] && other.get(this.size() - 1) == this.cols[this.size() - 1];
            }
            for (int i = 0; i < this.size(); ++i) {
                if (other.get(i) == this.cols[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IColIndex combine(IColIndex other) {
        int minCombined;
        int maxCombined;
        int sl;
        int sr = other.size();
        if (sr + (sl = this.size()) == (maxCombined = Math.max(this.get(this.size() - 1), other.get(other.size() - 1))) - (minCombined = Math.min(this.get(0), other.get(0))) + 1) {
            return new RangeIndex(minCombined, maxCombined + 1);
        }
        int[] ret = new int[sr + sl];
        int pl = 0;
        int pr = 0;
        int i = 0;
        while (pl < sl && pr < sr) {
            int vr;
            int vl = this.get(pl);
            if (vl < (vr = other.get(pr))) {
                ret[i++] = vl;
                ++pl;
                continue;
            }
            ret[i++] = vr;
            ++pr;
        }
        while (pl < sl) {
            ret[i++] = this.get(pl++);
        }
        while (pr < sr) {
            ret[i++] = other.get(pr++);
        }
        return ColIndexFactory.create(ret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(Arrays.toString(this.cols));
        return sb.toString();
    }

    @Override
    public int[] getReorderingIndex() {
        int[] sortedIndices = IntStream.range(0, this.cols.length).boxed().sorted((i, j) -> Integer.valueOf(this.cols[i]).compareTo(this.cols[j])).mapToInt(ele -> ele).toArray();
        return sortedIndices;
    }

    @Override
    public boolean isSorted() {
        for (int i = 1; i < this.cols.length; ++i) {
            if (this.cols[i - 1] <= this.cols[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public IColIndex sort() {
        int[] ret = new int[this.cols.length];
        System.arraycopy(this.cols, 0, ret, 0, this.cols.length);
        Arrays.sort(ret);
        return ColIndexFactory.create(ret);
    }

    @Override
    public boolean contains(int i) {
        if (i < this.cols[0] || i > this.cols[this.cols.length - 1]) {
            return false;
        }
        int id = Arrays.binarySearch(this.cols, 0, this.cols.length, i);
        return id >= 0;
    }

    @Override
    public double avgOfIndex() {
        double s = 0.0;
        for (int i = 0; i < this.cols.length; ++i) {
            s += (double)this.cols[i];
        }
        return s / (double)this.cols.length;
    }

    protected class ArrayIterator
    implements IIterate {
        int id = 0;

        protected ArrayIterator() {
        }

        @Override
        public int next() {
            return ArrayIndex.this.cols[this.id++];
        }

        @Override
        public boolean hasNext() {
            return this.id < ArrayIndex.this.cols.length;
        }

        @Override
        public int v() {
            return ArrayIndex.this.cols[this.id];
        }

        @Override
        public int i() {
            return this.id;
        }
    }
}

