/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockDRB;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class DenseBlockFP64DEDUP
extends DenseBlockDRB {
    private static final long serialVersionUID = -4012376952006079198L;
    private double[][] _data;
    private int _distinct = 0;

    public void setDistinct(int d) {
        this._distinct = d;
    }

    protected DenseBlockFP64DEDUP(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    public int getNrDistinctRows() {
        return this._distinct;
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data[bix] = new double[length];
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        if (rlen > this._rlen) {
            this._data = new double[rlen][];
        } else {
            if (this._data == null) {
                this._data = new double[rlen][];
            }
            if (v == 0.0) {
                for (int i = 0; i < rlen; ++i) {
                    this._data[i] = null;
                }
            } else {
                for (int i = 0; i < rlen; ++i) {
                    if (odims[0] > this._odims[0] || this._data[i] == null) {
                        this.allocateBlock(i, odims[0]);
                    }
                    Arrays.fill(this._data[i], 0, odims[0], v);
                }
            }
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public void resetNoFill(int rlen, int[] odims) {
        if (this._data == null || rlen > this._rlen) {
            this._data = new double[rlen][];
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.FP64 == vt;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.length * (long)this._odims[0] : -1L;
    }

    @Override
    public long countNonZeros() {
        long nnz = 0L;
        HashMap<double[], Long> cache = new HashMap<double[], Long>();
        for (int i = 0; i < this._rlen; ++i) {
            double[] row = this._data[i];
            if (row == null) continue;
            Long count = cache.getOrDefault(row, null);
            if (count == null) {
                count = this.countNonZeros(i);
                cache.put(row, count);
            }
            nnz += count.longValue();
        }
        this._distinct = cache.size();
        return nnz;
    }

    @Override
    public int countNonZeros(int r) {
        return this._data[r] == null ? 0 : UtilFunctions.computeNnz(this._data[r], 0, this._odims[0]);
    }

    @Override
    public long countNonZeros(int rl, int ru, int ol, int ou) {
        long nnz = 0L;
        HashMap<double[], Long> cache = new HashMap<double[], Long>();
        for (int i = rl; i < ru; ++i) {
            double[] row = this._data[i];
            if (row == null) continue;
            Long count = cache.getOrDefault(row, null);
            if (count == null) {
                count = UtilFunctions.computeNnz(this._data[i], ol, ou);
                cache.put(row, count);
            }
            nnz += count.longValue();
        }
        return nnz;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        int nnz = 0;
        int row_start = (int)Math.floor(start / this._odims[0]);
        int col_start = start % this._odims[0];
        for (int i = 0; i < length; ++i) {
            if (this._data[row_start] == null) {
                i += this._odims[0] - 1 - col_start;
                col_start = 0;
                ++row_start;
                continue;
            }
            nnz += this._data[row_start][col_start] != 0.0 ? 1 : 0;
            if (++col_start != this._odims[0]) continue;
            col_start = 0;
            ++row_start;
        }
        return nnz;
    }

    @Override
    public int pos(int r) {
        return 0;
    }

    @Override
    public int pos(int r, int c) {
        return c;
    }

    @Override
    public int pos(int[] ix) {
        int pos = ix[ix.length - 1];
        for (int i = 1; i < ix.length - 1; ++i) {
            pos += ix[i] * this._odims[i];
        }
        return pos;
    }

    @Override
    public int blockSize(int bix) {
        return 1;
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public boolean isContiguous(int rl, int ru) {
        return rl == ru;
    }

    @Override
    public double[] values(int r) {
        return this.valuesAt(r);
    }

    @Override
    public double[] valuesAt(int bix) {
        return this._data[bix] == null ? new double[this._odims[0]] : this._data[bix];
    }

    @Override
    public int index(int r) {
        return r;
    }

    @Override
    public int numBlocks() {
        return this._data.length;
    }

    @Override
    public int size(int bix) {
        return this._odims[0];
    }

    @Override
    public void incr(int r, int c) {
        this.incr(r, c, 1.0);
    }

    @Override
    public void incr(int r, int c, double delta) {
        if (this._data[r] == null) {
            this.allocateBlock(r, this._odims[0]);
        }
        double[] dArray = this._data[r];
        int n = c;
        dArray[n] = dArray[n] + delta;
    }

    @Override
    protected void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        if (this._data[bix] == null) {
            this.allocateBlock(bix, this._odims[0]);
        }
        Arrays.fill(this._data[bix], fromIndex, toIndex, v);
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this.set(bix, ix, v);
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        if (this._data[r] == null) {
            this._data[r] = new double[this._odims[0]];
        }
        this._data[r][c] = v;
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        if (v.length != this._odims[0]) {
            throw new RuntimeException("set Denseblock called with an array length [" + v.length + "], array to overwrite is of length [" + this._odims[0] + "]");
        }
        this._data[r] = v;
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        throw new NotImplementedException();
    }

    @Override
    public DenseBlock set(int rl, int ru, int ol, int ou, DenseBlock db) {
        if (!(db instanceof DenseBlockFP64DEDUP)) {
            throw new NotImplementedException();
        }
        HashMap<double[], double[]> cache = new HashMap<double[], double[]>();
        int len = ou - ol;
        int i = rl;
        int ix1 = 0;
        while (i < ru) {
            double[] row = db.values(ix1);
            double[] newRow = (double[])cache.get(row);
            if (newRow == null) {
                newRow = new double[len];
                System.arraycopy(row, 0, newRow, 0, len);
                cache.put(row, newRow);
            }
            this.set(i, newRow);
            ++i;
            ++ix1;
        }
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        return this.set(ix[0], this.pos(ix), v);
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        return this.set(ix[0], this.pos(ix), v);
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        return this.set(ix[0], this.pos(ix), Double.parseDouble(v));
    }

    @Override
    public double get(int r, int c) {
        if (this._data[r] == null) {
            return 0.0;
        }
        return this._data[r][c];
    }

    @Override
    public double get(int[] ix) {
        return this.get(ix[0], this.pos(ix));
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this.get(ix[0], this.pos(ix)));
    }

    @Override
    public long getLong(int[] ix) {
        return UtilFunctions.toLong(this.get(ix[0], this.pos(ix)));
    }

    public long estimateMemory() {
        if ((double)this._rlen * (double)this._odims[0] > 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        return DenseBlockFP64DEDUP.estimateMemory(this._rlen, this._odims[0], this._distinct);
    }

    public static long estimateMemory(int rows, int cols, int duplicates) {
        return DenseBlockFP64DEDUP.estimateMemory((long)rows, (long)cols, (long)duplicates);
    }

    public static long estimateMemory(long rows, long cols, long duplicates) {
        return (long)DenseBlock.estimateMemory(rows, cols) + (long)MemoryEstimates.doubleArrayCost(cols) * duplicates + (long)MemoryEstimates.objectArrayCost(rows);
    }
}

