/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.support;

import aQute.bnd.maven.support.CachedPom;
import aQute.bnd.maven.support.Maven;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.libg.filelock.DirectoryLock;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class MavenEntry
implements Closeable {
    final Maven maven;
    final File root;
    final File dir;
    final String path;
    final DirectoryLock lock;
    final Map<URI, CachedPom> poms = new HashMap<URI, CachedPom>();
    final File pomFile;
    final File artifactFile;
    final String pomPath;
    final File propertiesFile;
    Properties properties;
    private boolean propertiesChanged;
    FutureTask<File> artifact;
    private String artifactPath;

    MavenEntry(Maven maven, String path) {
        this.root = maven.repository;
        this.maven = maven;
        this.path = path;
        this.pomPath = String.valueOf(path) + ".pom";
        this.artifactPath = String.valueOf(path) + ".jar";
        this.dir = IO.getFile(maven.repository, path).getParentFile();
        this.dir.mkdirs();
        this.pomFile = new File(maven.repository, this.pomPath);
        this.artifactFile = new File(maven.repository, this.artifactPath);
        this.propertiesFile = new File(this.dir, "bnd.properties");
        this.lock = new DirectoryLock(this.dir, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPom getPom(URI[] urls) throws Exception {
        int n;
        MavenEntry mavenEntry = this;
        synchronized (mavenEntry) {
            URI[] uRIArray = urls;
            int n2 = urls.length;
            n = 0;
            while (n < n2) {
                URI url = uRIArray[n];
                CachedPom pom = this.poms.get(url);
                if (pom != null) {
                    return pom;
                }
                ++n;
            }
        }
        try {
            URI url;
            if (this.isValid()) {
                URI[] uRIArray = urls;
                n = urls.length;
                int n3 = 0;
                while (n3 < n) {
                    url = uRIArray[n3];
                    String valid = this.getProperty(url.toASCIIString());
                    if (valid != null) {
                        CachedPom cachedPom = this.createPom(url);
                        return cachedPom;
                    }
                    ++n3;
                }
                uRIArray = urls;
                n = urls.length;
                n3 = 0;
                while (n3 < n) {
                    url = uRIArray[n3];
                    if (this.verify(url, this.pomPath)) {
                        CachedPom cachedPom = this.createPom(url);
                        return cachedPom;
                    }
                    ++n3;
                }
            } else {
                this.dir.mkdirs();
                URI[] uRIArray = urls;
                n = urls.length;
                int n4 = 0;
                while (n4 < n) {
                    url = uRIArray[n4];
                    if (this.download(url, this.pomPath) && this.verify(url, this.pomPath)) {
                        this.artifact = new FutureTask<File>(new Callable<File>(){

                            @Override
                            public File call() throws Exception {
                                if (MavenEntry.this.download(url, MavenEntry.this.artifactPath)) {
                                    MavenEntry.this.verify(url, MavenEntry.this.artifactPath);
                                }
                                return MavenEntry.this.artifactFile;
                            }
                        });
                        this.maven.executor.execute(this.artifact);
                        CachedPom cachedPom = this.createPom(url);
                        return cachedPom;
                    }
                    ++n4;
                }
            }
            return null;
        }
        finally {
            this.saveProperties();
        }
    }

    private boolean download(URI repo, String path) throws MalformedURLException {
        try {
            URL url = this.toURL(repo, path);
            System.out.println("Downloading " + repo + " path " + path + " url " + url);
            File file = new File(this.root, path);
            IO.copy(url.openStream(), file);
            System.out.println("Downloaded " + url);
            return true;
        }
        catch (Exception e) {
            System.err.println("debug: " + e);
            return false;
        }
    }

    URL toURL(URI base, String path) throws MalformedURLException {
        StringBuilder r = new StringBuilder();
        r.append(((Object)base).toString());
        if (r.charAt(r.length() - 1) != '/') {
            r.append('/');
        }
        r.append(path);
        return new URL(r.toString());
    }

    private boolean isValid() {
        return this.pomFile.isFile() && this.pomFile.length() > 100L && this.artifactFile.isFile() && this.artifactFile.length() > 100L;
    }

    private void setProperty(String key, String value) {
        Properties properties = this.getProperties();
        properties.setProperty(key, value);
        this.propertiesChanged = true;
    }

    protected Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            File props = new File(this.dir, "bnd.properties");
            if (props.exists()) {
                try {
                    FileInputStream in = new FileInputStream(props);
                    this.properties.load(in);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.properties;
    }

    private String getProperty(String key) {
        Properties properties = this.getProperties();
        return properties.getProperty(key);
    }

    private void saveProperties() throws IOException {
        if (this.propertiesChanged) {
            FileOutputStream fout = new FileOutputStream(this.propertiesFile);
            try {
                this.properties.store(fout, "");
            }
            finally {
                this.properties = null;
                this.propertiesChanged = false;
                fout.close();
            }
        }
    }

    private CachedPom createPom(URI url) throws Exception {
        CachedPom pom = new CachedPom(this, url);
        pom.parse();
        this.poms.put(url, pom);
        this.setProperty(url.toASCIIString(), "true");
        return pom;
    }

    boolean verify(URI repo, String path) throws Exception {
        String[] stringArray = Maven.ALGORITHMS;
        int n = Maven.ALGORITHMS.length;
        int n2 = 0;
        while (n2 < n) {
            String algorithm = stringArray[n2];
            if (this.verify(repo, path, algorithm)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean verify(URI repo, String path, String algorithm) throws Exception {
        String digestPath = String.valueOf(path) + "." + algorithm;
        File actualFile = new File(this.root, path);
        if (this.download(repo, digestPath)) {
            File digestFile = new File(this.root, digestPath);
            final MessageDigest md = MessageDigest.getInstance(algorithm);
            IO.copy(actualFile, new OutputStream(){

                public void write(int c) throws IOException {
                    md.update((byte)c);
                }

                public void write(byte[] buffer, int offset, int length) {
                    md.update(buffer, offset, length);
                }
            });
            byte[] digest = md.digest();
            String source = IO.collect(digestFile).toUpperCase();
            String hex = Hex.toHexString(digest).toUpperCase();
            if (source.startsWith(hex)) {
                System.out.println("Verified ok " + actualFile + " digest " + algorithm);
                return true;
            }
        }
        System.out.println("Failed to verify " + actualFile + " for digest " + algorithm);
        return false;
    }

    public File getArtifact() throws Exception {
        if (this.artifact == null) {
            return this.artifactFile;
        }
        return this.artifact.get();
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void close() throws IOException {
    }

    public void remove() {
        if (this.dir.getParentFile() != null) {
            IO.delete(this.dir);
        }
    }
}

