/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.hibernate3.HibernateExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionFactoryBean
extends HibernateExceptionTranslator
implements FactoryBean<SessionFactory>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = false;
    private boolean exposeTransactionAwareSessionFactory = true;
    private SessionFactory sessionFactory;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    protected boolean isUseTransactionAwareDataSource() {
        return this.useTransactionAwareDataSource;
    }

    public void setExposeTransactionAwareSessionFactory(boolean exposeTransactionAwareSessionFactory) {
        this.exposeTransactionAwareSessionFactory = exposeTransactionAwareSessionFactory;
    }

    protected boolean isExposeTransactionAwareSessionFactory() {
        return this.exposeTransactionAwareSessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        SessionFactory rawSf = this.buildSessionFactory();
        this.sessionFactory = this.wrapSessionFactoryIfNecessary(rawSf);
        this.afterSessionFactoryCreation();
    }

    protected SessionFactory wrapSessionFactoryIfNecessary(SessionFactory rawSf) {
        return rawSf;
    }

    protected final SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("SessionFactory not initialized yet");
        }
        return this.sessionFactory;
    }

    public void destroy() throws HibernateException {
        this.logger.info((Object)"Closing Hibernate SessionFactory");
        try {
            this.beforeSessionFactoryDestruction();
        }
        finally {
            this.sessionFactory.close();
        }
    }

    public SessionFactory getObject() {
        return this.sessionFactory;
    }

    public Class<? extends SessionFactory> getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : SessionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected abstract SessionFactory buildSessionFactory() throws Exception;

    protected void afterSessionFactoryCreation() throws Exception {
    }

    protected void beforeSessionFactoryDestruction() {
    }
}

