/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisSetReactiveCommands;
import io.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ScanStream {
    private ScanStream() {
    }

    public static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands) {
        return ScanStream.scan(commands, Optional.empty());
    }

    public static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.scan(commands, Optional.of(scanArgs));
    }

    private static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        return scanArgs.map(commands::scan).orElseGet(commands::scan).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.scan((ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.scan((ScanCursor)c)) : Mono.empty()).flatMapIterable(KeyScanCursor::getKeys);
    }

    public static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key) {
        return ScanStream.hscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.hscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisHashReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return scanArgs.map(it -> commands.hscan(key, (ScanArgs)it)).orElseGet(() -> commands.hscan(key)).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.hscan(key, (ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.hscan(key, (ScanCursor)c)) : Mono.empty()).flatMapIterable(c -> {
            ArrayList list = new ArrayList(c.getMap().size());
            for (Map.Entry kvEntry : c.getMap().entrySet()) {
                list.add(KeyValue.fromNullable(kvEntry.getKey(), kvEntry.getValue()));
            }
            return list;
        });
    }

    public static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key) {
        return ScanStream.sscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.sscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisSetReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return scanArgs.map(it -> commands.sscan(key, (ScanArgs)it)).orElseGet(() -> commands.sscan(key)).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.sscan(key, (ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.sscan(key, (ScanCursor)c)) : Mono.empty()).flatMapIterable(ValueScanCursor::getValues);
    }

    public static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key) {
        return ScanStream.zscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.zscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisSortedSetReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return scanArgs.map(it -> commands.zscan(key, (ScanArgs)it)).orElseGet(() -> commands.zscan(key)).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.zscan(key, (ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.zscan(key, (ScanCursor)c)) : Mono.empty()).flatMapIterable(ScoredValueScanCursor::getValues);
    }
}

