/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleTest;
import org.languagetool.rules.patterns.PatternToken;

public class DemoPatternRuleTest
extends PatternRuleTest {
    private static final Language language = TestTools.getDemoLanguage();

    @Test
    public void testRules() throws IOException {
        this.runTestForLanguage(new Demo());
    }

    @Test
    public void testGrammarRulesFromXML2() throws IOException {
        new PatternRule("-1", language, Collections.emptyList(), "", "", "");
    }

    @Test
    public void testMakeSuggestionUppercase() throws IOException {
        JLanguageTool lt = new JLanguageTool(language);
        PatternToken patternToken = new PatternToken("Were", false, false, false);
        String message = "Did you mean: <suggestion>where</suggestion> or <suggestion>we</suggestion>?";
        PatternRule rule = new PatternRule("MY_ID", language, Collections.singletonList(patternToken), "desc", message, "msg");
        RuleMatch[] matches = rule.match(lt.getAnalyzedSentence("Were are in the process of ..."));
        Assert.assertEquals((long)1L, (long)matches.length);
        RuleMatch match = matches[0];
        List replacements = match.getSuggestedReplacements();
        Assert.assertEquals((long)2L, (long)replacements.size());
        Assert.assertEquals((Object)"Where", replacements.get(0));
        Assert.assertEquals((Object)"We", replacements.get(1));
    }

    @Test
    public void testRule() throws IOException {
        JLanguageTool lt = new JLanguageTool(language);
        PatternRule pr = this.makePatternRule("one");
        RuleMatch[] matches = pr.match(lt.getAnalyzedSentence("A non-matching sentence."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("A matching sentence with one match."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)25L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)28L, (long)matches[0].getToPos());
        Assert.assertEquals((long)-1L, (long)matches[0].getColumn());
        Assert.assertEquals((long)-1L, (long)matches[0].getLine());
        Assert.assertEquals((Object)"ID1", (Object)matches[0].getRule().getId());
        Assert.assertEquals((Object)"user visible message", (Object)matches[0].getMessage());
        Assert.assertEquals((Object)"short comment", (Object)matches[0].getShortMessage());
        matches = pr.match(lt.getAnalyzedSentence("one one and one: three matches"));
        Assert.assertEquals((long)3L, (long)matches.length);
        pr = this.makePatternRule("one two");
        matches = pr.match(lt.getAnalyzedSentence("this is one not two"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("this is two one"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("this is one two three"));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("one two"));
        Assert.assertEquals((long)1L, (long)matches.length);
        pr = this.makePatternRule("one|foo|xxxx two", false, true);
        matches = pr.match(lt.getAnalyzedSentence("one foo three"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("one two"));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("foo two"));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("one foo two"));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("y x z one two blah foo"));
        Assert.assertEquals((long)1L, (long)matches.length);
        pr = this.makePatternRule("one|foo|xxxx two|yyy", false, true);
        matches = pr.match(lt.getAnalyzedSentence("one, yyy"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("one yyy"));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("xxxx two"));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = pr.match(lt.getAnalyzedSentence("xxxx yyy"));
        Assert.assertEquals((long)1L, (long)matches.length);
    }

    @Test
    public void testSentenceStart() throws IOException {
        JLanguageTool lt = new JLanguageTool(language);
        PatternRule pr = this.makePatternRule("SENT_START One");
        Assert.assertEquals((long)0L, (long)pr.match(lt.getAnalyzedSentence("Not One word.")).length);
        Assert.assertEquals((long)1L, (long)pr.match(lt.getAnalyzedSentence("One word.")).length);
    }

    @Test
    public void testFormatMultipleSynthesis() throws Exception {
        String[] suggestions1 = new String[]{"blah blah", "foo bar"};
        Assert.assertEquals((Object)"This is how you should write: <suggestion>blah blah</suggestion>, <suggestion>foo bar</suggestion>.", (Object)PatternRuleMatcher.formatMultipleSynthesis((String[])suggestions1, (String)"This is how you should write: <suggestion>", (String)"</suggestion>."));
        String[] suggestions2 = new String[]{"test", " "};
        Assert.assertEquals((Object)"This is how you should write: <suggestion>test</suggestion>, <suggestion> </suggestion>.", (Object)PatternRuleMatcher.formatMultipleSynthesis((String[])suggestions2, (String)"This is how you should write: <suggestion>", (String)"</suggestion>."));
    }

    private PatternRule makePatternRule(String s) {
        return this.makePatternRule(s, false, false);
    }
}

