/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.cluster;

import com.hankcs.hanlp.mining.cluster.SparseVector;
import java.util.HashMap;
import java.util.Map;

public class Document<K> {
    K id_;
    SparseVector feature_;

    public Document(K id_, SparseVector feature_) {
        this.id_ = id_;
        this.feature_ = feature_;
    }

    public Document(K id_) {
        this(id_, new SparseVector());
    }

    K id() {
        return this.id_;
    }

    SparseVector feature() {
        return this.feature_;
    }

    void add_feature(int key, double value) {
        this.feature_.put(key, value);
    }

    void set_features(SparseVector feature) {
        this.feature_ = feature;
    }

    void clear() {
        this.feature_.clear();
    }

    void idf(HashMap<Integer, Integer> df, int ndocs) {
        for (Map.Entry entry : this.feature_.entrySet()) {
            Integer denom = df.get(entry.getKey());
            if (denom == null) {
                denom = 1;
            }
            entry.setValue((Double)entry.getValue() * Math.log(ndocs / denom));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return this.id_ != null ? this.id_.equals(document.id_) : document.id_ == null;
    }

    public int hashCode() {
        return this.id_ != null ? this.id_.hashCode() : 0;
    }
}

