/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.cluster;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SparseVector
extends TreeMap<Integer, Double> {
    @Override
    public Double get(Object key) {
        Double v = (Double)super.get(key);
        if (v == null) {
            return 0.0;
        }
        return v;
    }

    void normalize() {
        double nrm = this.norm();
        for (Map.Entry entry : this.entrySet()) {
            entry.setValue((Double)entry.getValue() / nrm);
        }
    }

    double norm_squared() {
        double sum = 0.0;
        for (Double point : this.values()) {
            sum += point * point;
        }
        return sum;
    }

    double norm() {
        return Math.sqrt(this.norm_squared());
    }

    void multiply_constant(double x) {
        for (Map.Entry entry : this.entrySet()) {
            entry.setValue((Double)entry.getValue() * x);
        }
    }

    void add_vector(SparseVector vec) {
        for (Map.Entry entry : vec.entrySet()) {
            Double v = this.get(entry.getKey());
            if (v == null) {
                v = 0.0;
            }
            this.put(entry.getKey(), v + (Double)entry.getValue());
        }
    }

    void sub_vector(SparseVector vec) {
        for (Map.Entry entry : vec.entrySet()) {
            Double v = this.get(entry.getKey());
            if (v == null) {
                v = 0.0;
            }
            this.put(entry.getKey(), v - (Double)entry.getValue());
        }
    }

    static double inner_product(SparseVector vec1, SparseVector vec2) {
        SparseVector other;
        Iterator it;
        if (vec1.size() < vec2.size()) {
            it = vec1.entrySet().iterator();
            other = vec2;
        } else {
            it = vec2.entrySet().iterator();
            other = vec1;
        }
        double prod = 0.0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            prod += (Double)entry.getValue() * other.get(entry.getKey());
        }
        return prod;
    }

    double cosine(SparseVector vec1, SparseVector vec2) {
        double norm1 = vec1.norm();
        double norm2 = vec2.norm();
        double result = 0.0;
        if (norm1 == 0.0 && norm2 == 0.0) {
            return result;
        }
        double prod = SparseVector.inner_product(vec1, vec2);
        result = prod / (norm1 * norm2);
        return Double.isNaN(result) ? 0.0 : result;
    }
}

