/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.RuleMatch;

public class RemoteRuleResult {
    private final boolean remote;
    private final boolean success;
    private final List<RuleMatch> matches;
    private final Map<AnalyzedSentence, List<RuleMatch>> sentenceMatches = new HashMap<AnalyzedSentence, List<RuleMatch>>();

    public RemoteRuleResult(boolean remote, boolean success, List<RuleMatch> matches) {
        this.remote = remote;
        this.success = success;
        this.matches = matches;
        for (RuleMatch match : matches) {
            this.sentenceMatches.compute(match.getSentence(), (sentence, ruleMatches) -> {
                if (ruleMatches == null) {
                    return new ArrayList<RuleMatch>(Collections.singletonList(match));
                }
                ruleMatches.add(match);
                return ruleMatches;
            });
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<RuleMatch> getMatches() {
        return this.matches;
    }

    public Set<AnalyzedSentence> matchedSentences() {
        return this.sentenceMatches.keySet();
    }

    public List<RuleMatch> matchesForSentence(AnalyzedSentence sentence) {
        return this.sentenceMatches.get(sentence);
    }
}

