/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends Rule {
    public static final String RULE_ID = "TOO_LONG_SENTENCE";
    private static final int DEFAULT_MAX_WORDS = 50;
    private static final boolean DEFAULT_ACTIVATION = false;
    protected int maxWords = 50;

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords, boolean defaultActive, boolean picky) {
        super(messages);
        int confWords;
        super.setCategory(Categories.STYLE.getCategory(messages));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        if (defaultWords > 0) {
            this.maxWords = defaultWords;
        }
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            this.maxWords = confWords;
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
        if (picky) {
            this.setTags(Collections.singletonList(Tag.picky));
        }
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        this(messages, userConfig, defaultWords, defaultActive, false);
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int defaultWords) {
        this(messages, userConfig, defaultWords, false);
    }

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig) {
        this(messages, userConfig, -1, false);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int getDefaultValue() {
        return this.maxWords;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 5;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 100;
    }

    @Override
    public String getConfigureText() {
        return this.messages.getString("guiLongSentencesText");
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_msg2"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String msg = this.getMessage();
        if (tokens.length < this.maxWords + 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int numWords = 0;
        int startPos = 0;
        for (AnalyzedTokenReadings aToken : tokens) {
            if (aToken.isSentenceStart() || aToken.isSentenceEnd() || aToken.isNonWord()) continue;
            int prevStartPos = startPos;
            startPos = aToken.getStartPos();
            if (++numWords <= this.maxWords) continue;
            RuleMatch ruleMatch = new RuleMatch(this, sentence, prevStartPos, aToken.getEndPos(), msg);
            ruleMatches.add(ruleMatch);
            break;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

