/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;

public abstract class AbstractAdvancedSynthesizerFilter
extends RuleFilter {
    protected abstract Synthesizer getSynthesizer();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        String postagSelect = this.getRequired("postagSelect", arguments);
        String lemmaSelect = this.getRequired("lemmaSelect", arguments);
        String postagFromStr = this.getOptional("postagFrom", arguments);
        String lemmaFromStr = this.getOptional("lemmaFrom", arguments);
        if (postagFromStr == null || lemmaFromStr == null) {
            return match;
        }
        int postagFrom = Integer.parseInt(postagFromStr);
        if (postagFrom < 1 || postagFrom > patternTokens.length) {
            throw new IllegalArgumentException("AdvancedSynthesizerFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + postagFromStr);
        }
        int lemmaFrom = Integer.parseInt(lemmaFromStr);
        if (lemmaFrom < 1 || lemmaFrom > patternTokens.length) {
            throw new IllegalArgumentException("AdvancedSynthesizerFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + lemmaFromStr);
        }
        String desiredLemma = this.getAnalyzedToken(patternTokens[lemmaFrom - 1], lemmaSelect).getLemma();
        String desiredPostag = this.getAnalyzedToken(patternTokens[postagFrom - 1], postagSelect).getPOSTag();
        AnalyzedToken token = new AnalyzedToken("", desiredPostag, desiredLemma);
        String[] replacements = this.getSynthesizer().synthesize(token, desiredPostag);
        if (replacements.length > 0) {
            RuleMatch newMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
            newMatch.setType(match.getType());
            ArrayList<String> replacementsList = new ArrayList<String>();
            replacementsList.addAll(match.getSuggestedReplacements());
            replacementsList.addAll(Arrays.asList(replacements));
            newMatch.setSuggestedReplacements(replacementsList);
            return newMatch;
        }
        return match;
    }

    private AnalyzedToken getAnalyzedToken(AnalyzedTokenReadings aToken, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return analyzedToken;
        }
        return null;
    }
}

