/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.languagemodel;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.languagemodel.LanguageModel;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.ngram.NGramUtils;
import opennlp.tools.util.StringList;

public class NGramLanguageModel
extends NGramModel
implements LanguageModel {
    private static final int DEFAULT_N = 3;
    private final int n;

    public NGramLanguageModel() {
        this(3);
    }

    public NGramLanguageModel(int n) {
        this.n = n;
    }

    public NGramLanguageModel(InputStream in) throws IOException {
        this(in, 3);
    }

    public NGramLanguageModel(InputStream in, int n) throws IOException {
        super(in);
        this.n = n;
    }

    public void add(String ... tokens) {
        this.add(new StringList(tokens), 1, this.n);
    }

    @Override
    public double calculateProbability(StringList tokens) {
        double probability = 0.0;
        if (this.size() > 0) {
            for (StringList ngram : NGramUtils.getNGrams(tokens, this.n)) {
                double score = this.stupidBackoff(ngram);
                if (!Double.isNaN(probability += Math.log(score))) continue;
                probability = 0.0;
                break;
            }
            probability = Math.exp(probability);
        }
        return probability;
    }

    @Override
    public double calculateProbability(String ... tokens) {
        double probability = 0.0;
        if (this.size() > 0) {
            for (String[] ngram : NGramUtils.getNGrams(tokens, this.n)) {
                double score = this.stupidBackoff(new StringList(ngram));
                if (!Double.isNaN(probability += Math.log(score))) continue;
                probability = 0.0;
                break;
            }
            probability = Math.exp(probability);
        }
        return probability;
    }

    @Override
    public StringList predictNextTokens(StringList tokens) {
        double maxProb = Double.NEGATIVE_INFINITY;
        StringList token = null;
        for (StringList ngram : this) {
            int i;
            String[] sequence = new String[ngram.size() + tokens.size()];
            for (i = 0; i < tokens.size(); ++i) {
                sequence[i] = tokens.getToken(i);
            }
            for (i = 0; i < ngram.size(); ++i) {
                sequence[i + tokens.size()] = ngram.getToken(i);
            }
            StringList sample = new StringList(sequence);
            double v = this.calculateProbability(sample);
            if (!(v > maxProb)) continue;
            maxProb = v;
            token = ngram;
        }
        return token;
    }

    @Override
    public String[] predictNextTokens(String ... tokens) {
        double maxProb = Double.NEGATIVE_INFINITY;
        String[] token = null;
        for (StringList ngram : this) {
            int i;
            String[] sequence = new String[ngram.size() + tokens.length];
            for (i = 0; i < tokens.length; ++i) {
                sequence[i] = tokens[i];
            }
            for (i = 0; i < ngram.size(); ++i) {
                sequence[i + tokens.length] = ngram.getToken(i);
            }
            double v = this.calculateProbability(sequence);
            if (!(v > maxProb)) continue;
            maxProb = v;
            token = new String[ngram.size()];
            for (int i2 = 0; i2 < ngram.size(); ++i2) {
                token[i2] = ngram.getToken(i2);
            }
        }
        return token;
    }

    private double stupidBackoff(StringList ngram) {
        int count = this.getCount(ngram);
        StringList nMinusOneToken = NGramUtils.getNMinusOneTokenFirst(ngram);
        if (nMinusOneToken == null || nMinusOneToken.size() == 0) {
            return (double)count / (double)this.size();
        }
        if (count > 0) {
            double countM1 = this.getCount(nMinusOneToken);
            if (countM1 == 0.0) {
                countM1 = this.size();
            }
            return (double)count / countM1;
        }
        return 0.4 * this.stupidBackoff(NGramUtils.getNMinusOneTokenLast(ngram));
    }
}

