/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Level;
import org.languagetool.Experimental;
import org.languagetool.RuleLogger;
import org.languagetool.RuleLoggerMessage;

@Experimental
public class OutputStreamLogger
extends RuleLogger {
    private final PrintStream stream;
    private final DateFormat dateFormat;
    private Level level = Level.WARNING;

    public OutputStreamLogger() {
        this(System.out);
    }

    public OutputStreamLogger(PrintStream out) {
        this.stream = out;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZ");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void log(RuleLoggerMessage message, Level logLevel) {
        if (logLevel.intValue() >= this.level.intValue()) {
            String timestamp = this.dateFormat.format(message.getTimestamp());
            this.stream.printf("%s > [%s]: *%s* %s - %s (%s)%n", this.getClass().getSimpleName(), timestamp, logLevel.getName(), message.getRuleId(), message.getMessage(), message.getLanguage());
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

