/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import opennlp.tools.formats.Conll02NameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class Conll03NameSampleStream
implements ObjectStream<NameSample> {
    private final LANGUAGE lang;
    private final ObjectStream<String> lineStream;
    private final int types;

    public Conll03NameSampleStream(LANGUAGE lang, ObjectStream<String> lineStream, int types) {
        this.lang = lang;
        this.lineStream = lineStream;
        this.types = types;
    }

    public Conll03NameSampleStream(LANGUAGE lang, InputStreamFactory in, int types) throws IOException {
        this.lang = lang;
        try {
            this.lineStream = new PlainTextByLineStream(in, StandardCharsets.UTF_8);
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.types = types;
    }

    @Override
    public NameSample read() throws IOException {
        String line;
        ArrayList<String> sentence = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        while ((line = this.lineStream.read()) != null && !StringUtil.isEmpty(line)) {
            if (line.startsWith("-DOCSTART-")) {
                isClearAdaptiveData = true;
                String emptyLine = this.lineStream.read();
                if (StringUtil.isEmpty(emptyLine)) continue;
                throw new IOException("Empty line after -DOCSTART- not empty: '" + emptyLine + "'!");
            }
            String[] fields = line.split(" ");
            if (LANGUAGE.EN.equals((Object)this.lang) && fields.length == 4) {
                sentence.add(fields[0]);
                tags.add(fields[3]);
                continue;
            }
            if (LANGUAGE.DE.equals((Object)this.lang) && fields.length == 5) {
                sentence.add(fields[0]);
                tags.add(fields[4]);
                continue;
            }
            throw new IOException("Incorrect number of fields per line for language: '" + line + "'!");
        }
        if (sentence.size() > 0) {
            ArrayList<Span> names = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < tags.size(); ++i) {
                String tag = (String)tags.get(i);
                if (tag.endsWith("PER") && (this.types & 1) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("ORG") && (this.types & 2) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("LOC") && (this.types & 4) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("MISC") && (this.types & 8) == 0) {
                    tag = "O";
                }
                if (tag.equals("O")) {
                    if (beginIndex == -1) continue;
                    names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                    continue;
                }
                if (tag.startsWith("B-")) {
                    if (beginIndex != -1) {
                        names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                    }
                    beginIndex = i;
                    endIndex = i + 1;
                    continue;
                }
                if (tag.startsWith("I-")) {
                    if (beginIndex == -1) {
                        beginIndex = i;
                        endIndex = i + 1;
                        continue;
                    }
                    if (!tag.endsWith(((String)tags.get(beginIndex)).substring(1))) {
                        names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                        beginIndex = i;
                        endIndex = i + 1;
                        continue;
                    }
                    ++endIndex;
                    continue;
                }
                throw new IOException("Invalid tag: " + tag);
            }
            if (beginIndex != -1) {
                names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
            }
            return new NameSample(sentence.toArray(new String[sentence.size()]), names.toArray(new Span[names.size()]), isClearAdaptiveData);
        }
        if (line != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }

    public static enum LANGUAGE {
        EN,
        DE;

    }
}

