/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;

public class ConfusionSetLoaderTest {
    @Test
    public void testLoadWithStrictLimits() throws IOException {
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream("/yy/confusion_sets.txt");){
            ConfusionSetLoader loader = new ConfusionSetLoader();
            Map map = loader.loadConfusionPairs(inputStream);
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)10));
            MatcherAssert.assertThat((Object)((List)map.get("there")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("there")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)10L));
            MatcherAssert.assertThat((Object)((List)map.get("their")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("their")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)10L));
            MatcherAssert.assertThat((Object)((List)map.get("foo")).size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("foo")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)5L));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("foo")).get(1)).getFactor(), (Matcher)CoreMatchers.is((Object)8L));
            MatcherAssert.assertThat((Object)((List)map.get("goo")).size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("goo")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)11L));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("goo")).get(1)).getFactor(), (Matcher)CoreMatchers.is((Object)12L));
            MatcherAssert.assertThat((Object)((List)map.get("lol")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((List)map.get("something")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((List)map.get("bar")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ConfusionPair)((List)map.get("bar")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)5L));
            List there = ((ConfusionPair)((List)map.get("there")).get(0)).getTerms();
            Assert.assertTrue((boolean)this.getAsString(there).contains("there - example 1"));
            Assert.assertTrue((boolean)this.getAsString(there).contains("their - example 2"));
            List their = ((ConfusionPair)((List)map.get("their")).get(0)).getTerms();
            Assert.assertTrue((boolean)this.getAsString(their).contains("there - example 1"));
            Assert.assertTrue((boolean)this.getAsString(their).contains("their - example 2"));
            Assert.assertFalse((boolean)this.getAsString(their).contains("comment"));
            List foo = ((ConfusionPair)((List)map.get("foo")).get(0)).getTerms();
            Assert.assertTrue((boolean)this.getAsString(foo).contains("foo"));
            List bar = ((ConfusionPair)((List)map.get("foo")).get(0)).getTerms();
            Assert.assertTrue((boolean)this.getAsString(bar).contains("bar"));
            List baz = ((ConfusionPair)((List)map.get("foo")).get(1)).getTerms();
            Assert.assertTrue((boolean)this.getAsString(baz).contains("baz"));
        }
    }

    private String getAsString(List<ConfusionString> confStrings) {
        StringBuilder sb = new StringBuilder();
        for (ConfusionString confusionString : confStrings) {
            sb.append(confusionString.getString()).append(" - ");
            sb.append(confusionString.getDescription());
            sb.append(" ");
        }
        return sb.toString();
    }
}

