/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

class DatabaseLogger {
    private static DatabaseLogger instance = null;
    static final int SQL_BATCH_SIZE = 1000;
    static final int SQL_BATCH_WAITING_TIME = 10000;
    private static final int POLLING_TIME = 1000;
    private static final int MAX_QUEUE_SIZE = 50000;
    private final BlockingQueue<DatabaseLogEntry> messages = new LinkedBlockingQueue<DatabaseLogEntry>();
    private SqlSessionFactory sessionFactory = null;
    private WorkerThread worker = null;
    private boolean disabled = true;

    public static DatabaseLogger getInstance() {
        if (instance == null) {
            instance = new DatabaseLogger();
        }
        return instance;
    }

    static void init(SqlSessionFactory factory) {
        DatabaseLogger.getInstance().start(factory);
    }

    private DatabaseLogger() {
    }

    private void start(SqlSessionFactory factory) {
        this.sessionFactory = factory;
        this.disabled = false;
        this.worker = new WorkerThread();
        this.worker.start();
    }

    public void disableLogging() {
        this.disabled = true;
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    public boolean isLogging() {
        return !this.disabled;
    }

    public void log(DatabaseLogEntry entry) {
        try {
            if (!this.disabled) {
                if (this.messages.size() < 50000) {
                    this.messages.put(entry);
                } else {
                    ServerTools.print("Logging queue has reached size limit; discarding new messages.");
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void createTestTables() {
        this.createTestTables(false);
    }

    void createTestTables(boolean mysql) {
        try (SqlSession session = this.sessionFactory.openSession(true);){
            String[] statements;
            for (String statement : statements = new String[]{"org.languagetool.server.LogMapper.createRuleMatches", "org.languagetool.server.LogMapper.createCheckLog", "org.languagetool.server.LogMapper.createMiscLog", "org.languagetool.server.LogMapper.createAccessLimits", "org.languagetool.server.LogMapper.createCheckError", "org.languagetool.server.LogMapper.createCacheStats", "org.languagetool.server.LogMapper.createServers", "org.languagetool.server.LogMapper.createClients"}) {
                if (mysql) {
                    session.insert(statement + "MySQL");
                    continue;
                }
                session.insert(statement);
            }
        }
    }

    void dropTestTables() {
        try (SqlSession session = this.sessionFactory.openSession(true);){
            session.delete("org.languagetool.server.LogMapper.dropRuleMatches");
            session.delete("org.languagetool.server.LogMapper.dropCheckLog");
            session.delete("org.languagetool.server.LogMapper.dropMiscLog");
            session.delete("org.languagetool.server.LogMapper.dropAccessLimits");
            session.delete("org.languagetool.server.LogMapper.dropCheckError");
            session.delete("org.languagetool.server.LogMapper.dropCacheStats");
            session.delete("org.languagetool.server.LogMapper.dropServers");
            session.delete("org.languagetool.server.LogMapper.dropClients");
        }
    }

    private class WorkerThread
    extends Thread {
        private WorkerThread() {
        }

        @Override
        public void run() {
            block17: {
                try (SqlSession session = DatabaseLogger.this.sessionFactory.openSession(ExecutorType.BATCH, false);){
                    while (!Thread.currentThread().isInterrupted()) {
                        int batchSize = 0;
                        long batchTime = System.currentTimeMillis();
                        while (!Thread.currentThread().isInterrupted() && batchSize < 1000 && System.currentTimeMillis() - batchTime < 10000L) {
                            DatabaseLogEntry entry;
                            if (DatabaseLogger.this.messages.size() > 1000) {
                                ServerTools.print(String.format("Logging queue filling up: %d entries", DatabaseLogger.this.messages.size()));
                            }
                            if ((entry = (DatabaseLogEntry)DatabaseLogger.this.messages.poll(1000L, TimeUnit.MILLISECONDS)) == null) continue;
                            ++batchSize;
                            session.insert(entry.getMappingIdentifier(), entry.getMapping());
                            DatabaseLogEntry followup = entry.followup();
                            if (followup == null) continue;
                            session.insert(followup.getMappingIdentifier(), followup.getMapping());
                            ++batchSize;
                        }
                        session.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (Thread.currentThread().isInterrupted()) break block17;
                    new WorkerThread().start();
                }
            }
        }
    }
}

