/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionSet;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ngrams.GoogleToken;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public abstract class ConfusionProbabilityRule
extends Rule {
    public static final String RULE_ID = "CONFUSION_RULE";
    public static final float MIN_COVERAGE = 0.5f;
    private static final double MIN_PROB = 0.0;
    private static final boolean DEBUG = false;
    private static final LoadingCache<String, Map<String, List<ConfusionSet>>> confSetCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, List<ConfusionSet>>>(){

        public Map<String, List<ConfusionSet>> load(@NotNull String fileInClassPath) throws IOException {
            ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader();
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(fileInClassPath);){
                Map<String, List<ConfusionSet>> map = confusionSetLoader.loadConfusionSet(confusionSetStream);
                return map;
            }
        }
    });
    private final Map<String, List<ConfusionSet>> wordToSets = new HashMap<String, List<ConfusionSet>>();
    private final LanguageModel lm;
    private final int grams;
    private final Language language;

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages);
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.NonConformance);
        for (String filename : this.getFilenames()) {
            String path = "/" + language.getShortCode() + "/" + filename;
            this.wordToSets.putAll((Map)confSetCache.getUnchecked((Object)path));
        }
        this.lm = Objects.requireNonNull(languageModel);
        this.language = Objects.requireNonNull(language);
        if (grams < 1 || grams > 5) {
            throw new IllegalArgumentException("grams must be between 1 and 5: " + grams);
        }
        this.grams = grams;
    }

    @NotNull
    protected List<String> getFilenames() {
        return Arrays.asList("confusion_sets.txt");
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        String text = sentence.getText();
        List<GoogleToken> tokens = GoogleToken.getGoogleTokens(text, true, this.getGoogleStyleWordTokenizer());
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (GoogleToken googleToken : tokens) {
            String token = googleToken.token;
            List<ConfusionSet> confusionSets = this.wordToSets.get(token);
            boolean uppercase = false;
            if (confusionSets == null && token.length() > 0 && Character.isUpperCase(token.charAt(0))) {
                confusionSets = this.wordToSets.get(StringTools.lowercaseFirstChar(token));
                uppercase = true;
            }
            if (confusionSets != null) {
                for (ConfusionSet confusionSet : confusionSets) {
                    Set<ConfusionString> set;
                    boolean isEasilyConfused = confusionSet != null;
                    if (!isEasilyConfused) continue;
                    Set<ConfusionString> set2 = set = uppercase ? confusionSet.getUppercaseFirstCharSet() : confusionSet.getSet();
                    ConfusionString betterAlternative = this.getBetterAlternativeOrNull(tokens.get(pos), tokens, set, confusionSet.getFactor());
                    if (betterAlternative == null || this.isException(text)) continue;
                    ConfusionString stringFromText = this.getConfusionString(set, tokens.get(pos));
                    String message = this.getMessage(stringFromText, betterAlternative);
                    RuleMatch match = new RuleMatch(this, sentence, googleToken.startPos, googleToken.endPos, message);
                    match.setSuggestedReplacement(betterAlternative.getString());
                    matches.add(match);
                }
            }
            ++pos;
        }
        return matches.toArray(new RuleMatch[matches.size()]);
    }

    protected boolean isException(String sentenceText) {
        return false;
    }

    @Override
    public String getDescription() {
        return Tools.i18n(this.messages, "statistics_rule_description", new Object[0]);
    }

    protected Tokenizer getGoogleStyleWordTokenizer() {
        return this.language.getWordTokenizer();
    }

    private String getMessage(ConfusionString textString, ConfusionString suggestion) {
        if (textString.getDescription() != null && suggestion.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest1", suggestion.getString(), suggestion.getDescription(), textString.getString(), textString.getDescription());
        }
        if (suggestion.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest2", suggestion.getString(), suggestion.getDescription());
        }
        return Tools.i18n(this.messages, "statistics_suggest3", suggestion.getString());
    }

    public void setConfusionSet(ConfusionSet set) {
        this.wordToSets.clear();
        for (ConfusionString word : set.getSet()) {
            this.wordToSets.put(word.getString(), Collections.singletonList(set));
        }
    }

    public int getNGrams() {
        return this.grams;
    }

    @Nullable
    private ConfusionString getBetterAlternativeOrNull(GoogleToken token, List<GoogleToken> tokens, Set<ConfusionString> confusionSet, long factor) {
        if (confusionSet.size() != 2) {
            throw new RuntimeException("Confusion set must be of size 2: " + confusionSet);
        }
        ConfusionString other = this.getAlternativeTerm(confusionSet, token);
        return this.getBetterAlternativeOrNull(token, tokens, other, factor);
    }

    private ConfusionString getAlternativeTerm(Set<ConfusionString> confusionSet, GoogleToken token) {
        for (ConfusionString s : confusionSet) {
            if (s.getString().equals(token.token)) continue;
            return s;
        }
        throw new RuntimeException("No alternative found for: " + token);
    }

    private ConfusionString getConfusionString(Set<ConfusionString> confusionSet, GoogleToken token) {
        for (ConfusionString s : confusionSet) {
            if (!s.getString().equalsIgnoreCase(token.token)) continue;
            return s;
        }
        throw new RuntimeException("Not found in set '" + confusionSet + "': " + token);
    }

    private ConfusionString getBetterAlternativeOrNull(GoogleToken token, List<GoogleToken> tokens, ConfusionString otherWord, long factor) {
        double p2;
        double p1;
        String word = token.token;
        if (this.grams == 3) {
            p1 = this.get3gramProbabilityFor(token, tokens, word);
            p2 = this.get3gramProbabilityFor(token, tokens, otherWord.getString());
        } else if (this.grams == 4) {
            p1 = this.get4gramProbabilityFor(token, tokens, word);
            p2 = this.get4gramProbabilityFor(token, tokens, otherWord.getString());
        } else {
            throw new RuntimeException("Only 3grams and 4grams are supported");
        }
        this.debug("P(" + word + ") = %.90f\n", p1);
        this.debug("P(" + otherWord + ") = %.90f\n", p2);
        return p2 >= 0.0 && p2 > p1 * (double)factor ? otherWord : null;
    }

    List<String> getContext(GoogleToken token, List<GoogleToken> tokens, String newToken, int toLeft, int toRight) {
        return this.getContext(token, tokens, Collections.singletonList(new GoogleToken(newToken, 0, newToken.length())), toLeft, toRight);
    }

    private List<String> getContext(GoogleToken token, List<GoogleToken> tokens, List<GoogleToken> newTokens, int toLeft, int toRight) {
        int pos = tokens.indexOf(token);
        if (pos == -1) {
            throw new RuntimeException("Token not found: " + token);
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 1;
        int added = 0;
        while (added < toLeft) {
            if (pos - i < 0) {
                result.clear();
                for (GoogleToken googleToken : newTokens) {
                    result.add(googleToken.token);
                }
                for (int j = pos - 1; j >= 0; --j) {
                    result.add(0, tokens.get((int)j).token);
                }
                return result;
            }
            if (!tokens.get(pos - i).isWhitespace()) {
                result.add(0, tokens.get((int)(pos - i)).token);
                ++added;
            }
            ++i;
        }
        for (GoogleToken googleToken : newTokens) {
            result.add(googleToken.token);
        }
        i = 1;
        added = 0;
        while (added < toRight) {
            if (pos + i >= tokens.size()) {
                result.add(".");
                ++added;
            } else if (!tokens.get(pos + i).isWhitespace()) {
                result.add(tokens.get((int)(pos + i)).token);
                ++added;
            }
            ++i;
        }
        return result;
    }

    private double get3gramProbabilityFor(GoogleToken token, List<GoogleToken> tokens, String term) {
        Probability ngram3Right;
        Probability ngram3Middle;
        Probability ngram3Left;
        List<GoogleToken> newTokens = GoogleToken.getGoogleTokens(term, false, this.getGoogleStyleWordTokenizer());
        if (newTokens.size() == 1) {
            ngram3Left = this.lm.getPseudoProbability(this.getContext(token, tokens, term, 0, 2));
            ngram3Middle = this.lm.getPseudoProbability(this.getContext(token, tokens, term, 1, 1));
            ngram3Right = this.lm.getPseudoProbability(this.getContext(token, tokens, term, 2, 0));
        } else if (newTokens.size() == 2) {
            ngram3Left = this.lm.getPseudoProbability(this.getContext(token, tokens, newTokens, 0, 1));
            ngram3Right = this.lm.getPseudoProbability(this.getContext(token, tokens, newTokens, 1, 0));
            ngram3Middle = new Probability((ngram3Left.getProb() + ngram3Right.getProb()) / 2.0, 1.0f);
        } else {
            throw new RuntimeException("Words that consists of more than 2 tokens (according to Google tokenization) are not supported yet: " + term + " -> " + newTokens);
        }
        if (ngram3Left.getCoverage() < 0.5f && ngram3Middle.getCoverage() < 0.5f && ngram3Right.getCoverage() < 0.5f) {
            this.debug("  Min coverage of %.2f not reached: %.2f, %.2f, %.2f, assuming p=0\n", Float.valueOf(0.5f), Float.valueOf(ngram3Left.getCoverage()), Float.valueOf(ngram3Middle.getCoverage()), Float.valueOf(ngram3Right.getCoverage()));
            return 0.0;
        }
        return ngram3Left.getProb() * ngram3Middle.getProb() * ngram3Right.getProb();
    }

    private double get4gramProbabilityFor(GoogleToken token, List<GoogleToken> tokens, String term) {
        Probability ngram4Left = this.lm.getPseudoProbability(this.getContext(token, tokens, term, 0, 3));
        Probability ngram4Middle = this.lm.getPseudoProbability(this.getContext(token, tokens, term, 1, 2));
        Probability ngram4Right = this.lm.getPseudoProbability(this.getContext(token, tokens, term, 3, 0));
        if (ngram4Left.getCoverage() < 0.5f && ngram4Middle.getCoverage() < 0.5f && ngram4Right.getCoverage() < 0.5f) {
            this.debug("  Min coverage of %.2f not reached: %.2f, %.2f, %.2f, assuming p=0\n", Float.valueOf(0.5f), Float.valueOf(ngram4Left.getCoverage()), Float.valueOf(ngram4Middle.getCoverage()), Float.valueOf(ngram4Right.getCoverage()));
            return 0.0;
        }
        return ngram4Left.getProb() * ngram4Middle.getProb() * ngram4Right.getProb();
    }

    private void debug(String message, Object ... vars) {
    }
}

