/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import morfologik.fsa.FSA;
import morfologik.fsa.builders.FSABuilder;
import morfologik.fsa.builders.FSASerializer;
import morfologik.tools.BinaryInput;
import morfologik.tools.CliTool;
import morfologik.tools.ExitStatus;
import morfologik.tools.SerializationFormat;
import morfologik.tools.ValidateFileExists;
import morfologik.tools.ValidateParentDirExists;

@Parameters(commandNames={"fsa_compile"}, commandDescription="Builds finite state automaton from \\n-delimited input.")
public class FSACompile
extends CliTool {
    @Parameter(names={"-i", "--input"}, description="The input sequences (one sequence per \\n-delimited line).", required=true, validateValueWith=ValidateFileExists.class)
    private Path input;
    @Parameter(names={"-o", "--output"}, description="The output automaton file.", required=true, validateValueWith=ValidateParentDirExists.class)
    private Path output;
    @Parameter(names={"-f", "--format"}, description="Automaton serialization format.")
    private SerializationFormat format = SerializationFormat.FSA5;
    @ParametersDelegate
    private final BinaryInput binaryInput;

    FSACompile() {
        this.binaryInput = new BinaryInput();
    }

    public FSACompile(Path input, Path output, SerializationFormat format, boolean acceptBom, boolean acceptCr, boolean ignoreEmpty) {
        this.input = FSACompile.checkNotNull(input);
        this.output = FSACompile.checkNotNull(output);
        this.binaryInput = new BinaryInput(acceptBom, acceptCr, ignoreEmpty);
    }

    @Override
    public ExitStatus call() throws Exception {
        List<byte[]> sequences = this.binaryInput.readBinarySequences(this.input, (byte)10);
        Collections.sort(sequences, FSABuilder.LEXICAL_ORDERING);
        FSA fsa = FSABuilder.build(sequences);
        FSASerializer serializer = this.format.getSerializer();
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(this.output, new OpenOption[0]));){
            serializer.serialize(fsa, (OutputStream)os);
        }
        return ExitStatus.SUCCESS;
    }

    public static void main(String[] args) {
        FSACompile.main(args, (CliTool)new FSACompile());
    }
}

